<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">

    @stack('meta')
    <meta id="csrf-token" content="{{ csrf_token() }}">
    <meta name="robots" content="all">

    <link rel="shortcut icon" href="{{ asset($setting->favicon) }}" type="image/x-icon">
    <!-- Bootstrap Core CSS -->
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/bootstrap.min.css') }}">
    <!-- Customizable CSS -->
    @stack('css')
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/main.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/blue.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/owl.carousel.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/owl.transitions.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/animate.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/rateit.css') }}">


    <link rel="stylesheet" href="{{ asset('assets/frontend/css/lightbox.css') }}">
    <link href="{{ asset('assets/backend/lib/select2/css/select2.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/bootstrap-select.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/style.css') }}">

    <!-- Icons/Glyphs -->
    <link rel="stylesheet" href="{{ asset('assets/frontend/css/font-awesome.css') }}">

    <!-- Fonts -->
    <link href='http://fonts.googleapis.com/css?family=Roboto:300,400,500,700' rel='stylesheet' type='text/css'>
    <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,300,400italic,600,600italic,700,700italic,800'
        rel='stylesheet' type='text/css'>
    <link href='https://fonts.googleapis.com/css?family=Montserrat:400,700' rel='stylesheet' type='text/css'>


</head>

<body class="cnt-home">
    <!-- ====================== HEADER ===================== -->
    @include('frontend.inc.header')

    <!-- ================ HEADER : END ========== -->
    @yield('content')

    <!-- ======= FOOTER ======= -->
    @include('frontend.inc.footer')
    <!-- ======= FOOTER : END======= -->


    @include('components.product.modal')
    <!-- For demo purposes – can be removed on production -->


    <!-- For demo purposes – can be removed on production : End -->
    

    <div class="floating-action">
        
        <div class="nps formContainer transitionOut shadow border">
            <div class="nps form">
                
                <div class="floating-logo">
                    <img src="{{asset('assets/frontend/images/steel-bazar-logo.png')}}" alt="Steel Bazar Logo" />
                </div>
                <div class="close-query-btn">
                    <button class="btn btn-danger" type="button"> &#x2715; </button>
                </div>
                <div class="floating-action-item">
                    <div class="floating-action-icon"><i class="fa fa-phone" style="margin: 6px !important"></i></div> 
                    <a href="tel:{{$setting->phone_1}}" class="floating-action-link" style="font-size: 16px; font-weight: 600; color: #fff;"> {{$setting->phone_1}}</a>
                </div>
                <div class="floating-action-item">
                    <div class="floating-action-icon"><i class="fa fa-whatsapp" style="margin: 6px !important"></i></div> 
                    <a href="https://wa.me/{{ $setting->whatsapp }}" class="floating-action-link" style="font-size: 16px; font-weight: 600; color: #fff;">{{ $setting->whatsapp }}</a>
                </div>
                
                <div class="floating-action-item">
                    <div class="floating-action-icon"><i class="fa fa-envelope" style="margin: 5px !important"></i></div> 
                    <a href="mailto:{{ $setting->email }}" class="floating-action-link" style="font-size: 16px; font-weight: 600; color: #fff;">{{$setting->email}}</a>
                </div>
                
                
            </div>
        </div>
        <a class="nps floatingActionButton bounce">Contact For Query</a>
    </div>
    @stack('modal')
    <!-- JavaScripts placed at the end of the document so the pages load faster -->
    <!--<script type="text/javascript" src="{{ asset('assets/frontend/js/jquery-1.11.1.min.js') }}"></script>-->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>
    <script>
            if ($(window).width() < 776) {
                $("#mobile-view-btn").show();
                $("#mobile-header").show();
                $("#desktop-header").hide();
                $("#desktop-view-btn").hide();
                $("#mobile-footer").show();
                $("#desktop-footer").hide();
                $("#side-menu").hide();
                const parent = document.getElementById('row-reverse');
                const arr = Array.from(parent.childNodes);
                arr.reverse();
                parent.append(...arr);
            } else {
                $("#mobile-view-btn").hide();
                $("#mobile-header").hide();
                $("#desktop-header").show();
                $("#mobile-footer").hide();
                $("#desktop-footer").show();
                $("#desktop-view-btn").show();
                $("#side-menu").show();
            }
            
            // var selectedClass=document.querySelector('.mobile-nav');
            function showNav(){
                var selectedClass=document.querySelector('.mobile-nav');
                selectedClass.classList.add('mobile-nav-active')
            }
            
            
            function hideNav(){
                var selectedClass=document.querySelector('.mobile-nav');
                selectedClass.classList.remove('mobile-nav-active')
            }
            function openProfile(){
                var targetClass=document.querySelector('.mobile-topbar-nav');
                targetClass.classList.add('mobile-topbar-nav-active')
            }
            function closeProfile(){
                var targetClass=document.querySelector('.mobile-topbar-nav');
                targetClass.classList.remove('mobile-topbar-nav-active')
            }
        $(document).ready(function () {
            $(".nps.floatingActionButton").click( function() {
		$(".nps.formContainer").addClass("transitionIn").removeClass("transitionOut");
		$(this).removeClass("thankYou")
	});
	
    	$(".close-query-btn").click( function() {
    		$(".nps.formContainer").addClass("transitionOut").removeClass("transitionIn");
    	});
    	
    	$(".nps.button").click( function() {
    		setTimeout(function(){
    			$(".nps.floatingActionButton").fadeOut();	
    		}, 3000);
    		$(".nps.floatingActionButton").addClass("thankYou").text("Thank you ❤️");
    		$(".nps.formContainer").addClass("transitionOut").removeClass("transitionIn");
    	});
            $("#toggler-btn").click(function () {
                console.log('clicked');
                $(".mobile-nav").addClass("mobile-nav-active");
            });
            $(".close-btn").click(function () {
                $(".mobile-nav").removeClass("mobile-nav-active");
            });
            $(".indicator-btn").click(function () {
                $(".mobile-topbar-nav").addClass("mobile-topbar-nav-active");
            });
            $(".topbar-close-btn").click(function () {
                $(".mobile-topbar-nav").removeClass("mobile-topbar-nav-active");
            });
            $("#mobile-header .category-icon").click(function () {
                $(this).children("#mobile-header .category-icon i").toggleClass("fa-minus");
                $(this).parent().toggleClass("category-active");
                $(this).parent().siblings(".category-sub-menu").slideToggle();
            });
            $("#mobile-header .sub-category-icon").click(function () {
                $(this).children("#mobile-header .sub-category-icon i").toggleClass("fa-minus");
                $(this).parent().toggleClass("category-active");
                $(this).parent().siblings(".category-sub-sub-menu").slideToggle();
            });
            $(".bottom-nav-item").click(function () {
                $(".bottom-nav-link").removeClass("active-bottom-nav");
                $(this).children().addClass("active-bottom-nav");
            });
            
        });
    </script>
    <script type="text/javascript" src="{{ asset('assets/frontend/js/bootstrap.min.js') }}"></script>

    <script type="text/javascript" src="{{ asset('assets/frontend/js/bootstrap-hover-dropdown.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/frontend/js/owl.carousel.min.js') }}"></script>

    <script type="text/javascript" src="{{ asset('assets/frontend/js/echo.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/frontend/js/jquery.easing-1.3.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/frontend/js/bootstrap-slider.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/frontend/js/jquery.rateit.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/frontend/js/lightbox.min.js') }}"></script>
    <script src="{{ asset('assets/backend/lib/select2/js/select2.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/frontend/js/bootstrap-select.min.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/frontend/js/wow.min.js') }}"></script>
    <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery.lazy/1.7.9/jquery.lazy.min.js"></script>
    <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery.lazy/1.7.9/jquery.lazy.plugins.min.js"></script>
    <script type="text/javascript" src="{{ asset('assets/frontend/js/scripts.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/backend/js/sweetalert2@11.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/backend/js/axios.min.js') }}" type="text/javascript"></script>
    <script type="text/javascript" src="{{ asset('assets/frontend/js/custom.js') }}" type="text/javascript"></script>
    <script type="text/javascript">
        $(function() {
            $('img').lazy();
        });
        axios.defaults.headers.common['X-CSRF-TOKEN'] = $('meta#csrf-token').attr('content');
        
        
        function viewProduct(id) {
            let url = '/product/view/' + id;

            axios.get(url)
                .then(function(response) {
                    if (response.status === 200) {
                        let product = response.data.product;
                        let category = response.data.category;
                        let brand = response.data.brand;
                        let colorBn = response.data.colorsBn;
                        let colorEn = response.data.colorsEn;
                        let sizeBn = response.data.sizesBn;
                        let sizeEn = response.data.sizesEn;
                        $('.image').attr('src', '/' + product.product_thumbnail);
                        $('.modal-product-id').val(product.id);
                        $('#color').empty();
                        $('#size').empty();
                        $('#price').empty();
                        $('.discount-price-modal').empty();
                        if (product.discount_price == null) {
                            $('.product-price').text(product.selling_price);
                        } else {
                            $('.discount-price-modal').text(product.discount_price);
                            $('#price').addClass('delete').text(product.selling_price);
                        }
                        @if (session()->get('language') === 'bangla')
                            $('.product-name').text(product.product_name_bn);
                            $('.category').text(category.category_name_bn);
                            $('.brand').text(brand.brand_name_bn);
                            $('.code').text(product.product_code);
                            if (product.product_quantity_bn !== null) {
                                $('.stock').text('মজুদ আছে').addClass('in-stock');
                            } else {
                                $('.stock').text('মজুদ নেই').addClass('out-stock');
                            }
                            $('.stock').text(product.product_code);
                            if (product.product_color_bn !== null) {

                                $.each(colorBn, function(key, value) {
                                    $('#color').append(
                                        '<option value="' + value + '">' + value + '</option>'
                                    )
                                })

                                $('.color-group').removeClass('d-none')
                            } else {
                                $('.color-group').addClass('d-none')
                            }
                            if (product.product_size_bn !== null) {

                                $.each(sizeBn, function(key, value) {
                                    $('#size').append(
                                        '<option value="' + value + '">' + value + '</option>'
                                    )
                                })
                                $('.size-group').removeClass('d-none')
                            } else {
                                $('.size-group').addClass('d-none');
                            }
                        @else
                            $('.product-name').text(product.product_name_en);
                            $('.category').text(category.category_name_en);
                            $('.brand').text(brand.brand_name_en);
                            $('.code').text(product.product_code);
                            if (product.product_quantity_en !== null) {
                                $('.stock').text('In Stack').addClass('in-stock');
                            } else {
                                $('.stock').text('Out of Stack').addClass('out-stock');
                            }
                            if (product.product_color_en !== null) {

                                $.each(colorEn, function(key, value) {
                                    $('#color').append(
                                        '<option value="' + value + '">' + value + '</option>'
                                    )
                                })
                                $('.color-group').removeClass('d-none')
                            } else {
                                $('.color-group').addClass('d-none');
                            }
                            if (product.product_size_en !== null) {

                                $.each(sizeEn, function(key, value) {
                                    $('#size').append(
                                        '<option value="' + value + '">' + value + '</option>'
                                    )
                                })
                                $('.size-group').removeClass('d-none')
                            } else {
                                $('.size-group').addClass('d-none');
                            }
                        @endif
                    }
                }).catch(function(error) {
                    console.log(error);
                })
        }

        function addToCart() {
            $('#view-product-modal').modal('hide');
            let id = $('.modal-product-id').val();
            let url = "/product/add-to-cart/" + id;

            axios.post(url, {
                    'id': id,
                    'color': $('.color').val(),
                    'size': $('.size').val(),
                    'quantity': $('.quantity').val(),
                    '_token': '{{ csrf_token() }}',
                })
                .then(function(response) {
                    getCartData();

                    //discountWithCoupon();
                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 3000,
                    })
                    if ($.isEmptyObject(response.error)) {
                        Toast.fire({
                            icon: 'success',
                            text: response.data + " Added On your cart",
                        })
                    } else {
                        Toast.fire({
                            icon: 'error',
                            text: response.data + " Add fail On your cart",
                        })
                    }
                }).catch(function(error) {
                    console.log(error)
                })
        }

        

        function removeMiniCartData() {
            let rawId = $('.remove-from-cart').val();
            axios.get("/product/remove-from-cart/" + rawId)
                .then(function(response) {
                    $('#cart-table').empty();
                    $('#coupon-code').val('');
                    $('#coupon-section').show();
                    getAllCartData();
                    getCartData();
                    discountWithCoupon();
                    const Toast = Swal.mixin({
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 3000,
                    })
                    if ($.isEmptyObject(response.error)) {
                        Toast.fire({
                            icon: 'success',
                            text: response.data,
                        })
                    } else {
                        Toast.fire({
                            icon: 'error',
                            text: 'Product remove failed from cart',
                        })
                    }
                }).catch(function(error) {

                })
        }

        function addToWishList(id) {
            @if (Auth()->check())
                axios.post("/user/wishlist-add/" + id, {
                        'id': id,
                        '_token': "{{ csrf_token() }}",
                    })
                    .then(function(response) {
                        const Toast = Swal.mixin({
                            toast: true,
                            position: 'top-end',
                            showConfirmButton: false,
                            timer: 3000,
                        })
                        if ($.isEmptyObject(response.error)) {
                            Toast.fire({
                                icon: 'success',
                                text: response.data,
                            })
                        } else {
                            Toast.fire({
                                icon: 'error',
                                text: 'Porduct Add into Wishlist Fail',
                            })
                        }
                    }).catch(function(error) {

                    })
            @else
                Swal.fire({
                    icon: 'error',
                    text: "You have to login first. Otherwise You can't add this product on your wishlist",
                })
            @endif
        }
        @if (session()->has('success'))
            Swal.fire({
                icon: 'success',
                text: "{{ session('success') }}"
            })
        @endif
        @if (session()->has('error'))
            Swal.fire({
                icon: 'error',
                text: "{{ session('error') }}"
            })
        @endif
        $('#checkout').on('click', function() {

            @if (Auth()->check())
            @else
                Swal.fire({
                    title: "Your not logged in!",
                    text: 'Please login first',
                    icon: 'warning',
                })
            @endif
        })
        
    </script>
    @yield('scripts')
    <script type="text/javascript"
        src="https://platform-api.sharethis.com/js/sharethis.js#property=6385e31b1b929e0012813f62&product=inline-share-buttons&source=platform"
        async="async"></script>

</body>

</html>
