@extends('layouts.frontend-layout')
@push('meta')
    @include('components.seo.seo', [
        'title' => $setting->title,
        'description' => $setting->seo_description,
        'keywords' => $setting->seo_meta,
        'image' => $setting->logo,
        'url' => route('home'),
    ])
@endpush
@section('home', 'active')
@section('content')

    <div class="body-content outer-top-xs" id="top-banner-and-menu">

        <div class="breadcrumb">
            <div class="container">
                <div class="breadcrumb-inner">
                    <ul class="list-inline list-unstyled">
                        <li><a href="{{route('home')}}">Home</a></li>
                        <li class='active'>{{ $subSubCategory->subsubcategory_name_en }}</li>
                    </ul>
                </div><!-- /.breadcrumb-inner -->
            </div><!-- /.container -->
        </div><!-- /.breadcrumb -->
        <div class="outer-top-xs">
            <div class='container'>
                <div class='row' id="row-reverse">
                    <div class='col-md-3 sidebar'>
                        <!-- ===================== TOP NAVIGATION ================ -->
                        @include('components.side-nav')
                        <!-- ============= TOP NAVIGATION : END =========== -->
                        <div class="sidebar-module-container">

                            <div class="sidebar-filter">
                                
                                <!-- ============================================== PRICE SILDER============================================== -->
                                <div class="sidebar-widget wow fadeInUp">
                                    @includeIf('components.price-search.price-search-form')
                                </div><!-- /.sidebar-widget -->
                                <!-- ======== PRICE SILDER : END ========= -->



                            </div><!-- /.sidebar-filter -->
                        </div><!-- /.sidebar-module-container -->
                    </div><!-- /.sidebar -->
                    <div class='col-md-9'>
                        <!-- ============= SECTION – HERO ======= -->

                        <!--<div id="category" class="category-carousel hidden-xs">-->
                        <!--    <div class="item">-->
                        <!--        <div class="image">-->
                        <!--            <img src="/assets/frontend/images/banners/cat-banner-1.jpg" alt=""-->
                        <!--                class="img-responsive">-->
                        <!--        </div>-->
                        <!--        <div class="container-fluid">-->
                        <!--            <div class="caption vertical-top text-left">-->
                        <!--                <div class="big-text">-->
                        <!--                    Big Sale-->
                        <!--                </div>-->

                        <!--                <div class="excerpt hidden-sm hidden-md">-->
                        <!--                    Save up to 49% off-->
                        <!--                </div>-->
                        <!--                <div class="excerpt-normal hidden-sm hidden-md">-->
                        <!--                    Lorem ipsum dolor sit amet, consectetur adipiscing elit-->
                        <!--                </div>-->

                        <!--            </div>-->
                        <!--        </div>-->
                        <!--    </div>-->
                        <!--</div>-->




                        <!-- ========================================= SECTION – HERO : END ========================================= -->
                        <div class="clearfix filters-container m-t-10">
                            <div class="row">
                                <div class="col col-sm-6 col-md-6">
                                    <div class="filter-tabs">
                                        <ul id="filter-tabs" class="nav nav-tabs nav-tab-box nav-tab-fa-icon">
                                            <li class="active">
                                                <a data-toggle="tab" href="#grid-container"><i
                                                        class="icon fa fa-th-large"></i>Grid</a>
                                            </li>
                                            <li><a data-toggle="tab" href="#list-container"><i
                                                        class="icon fa fa-th-list"></i>List</a></li>
                                        </ul>
                                    </div><!-- /.filter-tabs -->
                                </div><!-- /.col -->
                                
                                <div class="col col-sm-6 col-md-6 text-right">
                                    <div class="pagination-container">
                                        <ul class="list-inline list-unstyled">
                                            {{$products->links()}}
                                        </ul><!-- /.list-inline -->
                                    </div><!-- /.pagination-container -->
                                </div><!-- /.col -->
                            </div><!-- /.row -->
                        </div>
                        <div class="search-result-container ">
                            <div id="myTabContent" class="tab-content category-list">
                                <div class="tab-pane active " id="grid-container">
                                    <div class="category-product">
                                        <div class="row">

                                            @foreach ($products as $product)
                                                <div class="col-sm-6 col-md-4 wow fadeInUp">
                                                    <div class="products">

                                                        @include('components.product.product', [
                                                            'product' => $product,
                                                        ])

                                                    </div><!-- /.products -->
                                                </div><!-- /.item -->
                                            @endforeach

                                        </div><!-- /.row -->
                                    </div><!-- /.category-product -->

                                </div><!-- /.tab-pane -->

                                <div class="tab-pane " id="list-container">
                                    <div class="category-product">
                                        @foreach ($products as $product)
                                            <div class="category-product-inner wow fadeInUp">
                                                <div class="products">
                                                    <div class="product-list product">
                                                        <div class="row product-list-row">
                                                            <div class="col col-sm-4 col-lg-4">
                                                                <div class="product-image">
                                                                    <div class="image">
                                                                        <a href="{{ route('product.detail', ['id' => $product->id, 'slug' => $product->product_slug_en]) }}">
                                                                            <img src="{{ asset($product->product_thumbnail) }}"
                                                                                   alt="{{ $product->product_name_en }}">
                                                                        </a>
                                                                    </div><!-- /.image -->
                                                                </div><!-- /.product-image -->
                                                            </div><!-- /.col -->
                                                            <div class="col col-sm-8 col-lg-8">
                                                                <div class="product-info">
                                                                    <h3 class="name">
                                                                        <a href="{{ route('product.detail', ['id' => $product->id, 'slug' => $product->product_slug_en]) }}">
                                                                            {{ $product->product_name_en }}
                                                                        </a>
                                                                    </h3>
                                                                    <div class="rating rateit-small"></div>
                                                                    <div class="product-price">
                                                                        @if ($product->discount == null)
                                                                            <span class="price">
                                                                                ৳{{ $product->discount_price }}
                                                                            </span>
                                                                        @else
                                                                            <span class="price">
                                                                                ৳{{ $product->discount_price }}
                                                                            </span>
                                                                            <span class="price-before-discount">
                                                                                ৳{{ $product->selling_price }}

                                                                            </span>
                                                                        @endif

                                                                    </div><!-- /.product-price -->
                                                                    <div class="description m-t-10">
                                                                        {!! $product->short_desc_en !!}
                                                                    </div>
                                                                    <div class="cart clearfix animate-effect">
                                                                        <div class="action">
                                                                            <ul class="list-unstyled">
                                                                                <li class="add-cart-button btn-group">
                                                                                    <button class="btn btn-primary icon"
                                                                                        data-toggle="dropdown"
                                                                                        type="button">
                                                                                        <i class="fa fa-shopping-cart"></i>
                                                                                    </button>
                                                                                    <button
                                                                                        class="btn btn-primary cart-btn"
                                                                                        type="button">
                                                                                        Add to Cart
                                                                                    </button>

                                                                                </li>

                                                                                <li class="lnk wishlist">
                                                                                    <a class="add-to-cart"
                                                                                        href="detail.html"
                                                                                        title="Wishlist">
                                                                                        <i class="icon fa fa-heart"></i>
                                                                                    </a>
                                                                                </li>

                                                                                <li class="lnk">
                                                                                    <a class="add-to-cart"
                                                                                        href="detail.html"
                                                                                        title="Compare">
                                                                                        <i class="fa fa-signal"></i>
                                                                                    </a>
                                                                                </li>
                                                                            </ul>
                                                                        </div><!-- /.action -->
                                                                    </div><!-- /.cart -->

                                                                </div><!-- /.product-info -->
                                                            </div><!-- /.col -->
                                                        </div><!-- /.product-list-row -->
                                                        @if ($product->discount == null)
                                                            <div class="tag new">
                                                                <span>
                                                                    New
                                                                </span>
                                                            </div>
                                                        @else
                                                            <div class="tag hot">
                                                                <span>
                                                                    {{ $product->discount }}%
                                                                </span>
                                                            </div>
                                                        @endif
                                                    </div><!-- /.product-list -->
                                                </div><!-- /.products -->
                                            </div><!-- /.category-product-inner -->
                                        @endforeach

                                    </div><!-- /.category-product -->
                                </div><!-- /.tab-pane #list-container -->
                            </div><!-- /.tab-content -->
                            <div class="clearfix filters-container">

                                <div class="text-right">
                                    <div class="pagination-container">
                                        <ul class="list-inline list-unstyled">
                                            {{$products->links()}}
                                        </ul><!-- /.list-inline -->
                                    </div><!-- /.pagination-container -->

                                </div><!-- /.text-right -->

                            </div><!-- /.filters-container -->

                        </div><!-- /.search-result-container -->

                    </div><!-- /.col -->
                </div><!-- /.row -->

            </div><!-- /.container -->

        </div><!-- /.body-content -->



    @endsection
