@php
use Gloudemans\Shoppingcart\Facades\Cart;
@endphp
<header class="header-style-1">
    <!-- ===== TOP MENU ============ -->
    <div id="mobile-header" style="display: none;">
        <div class="header-top-row">
            <div class="toggler">
                <button type="button" class="toggler-btn" id="toggler-btn" onclick="showNav()">
                    <i class="icon fa fa-align-justify fa-fw"></i>
                </button>
                    <div class="mobile-nav">
                        <div class="head"> <span> Categories</span>
                            <button type="button" class="close-btn" id="close-btn" onclick="hideNav()">
                                <i class="icon fa fa-times fa-fw"></i>
                            </button>
                        </div>
    
                        @includeIf('components.navbar.main-nav')
                    </div>
                
                
            </div>
            <div class="search-box">
                <div class="search-area">
                    <form action="{{ route('product.search') }}" method="GET">
                        
                        <div class="control-group">
                            <input class="search-field" name="search" placeholder="Search here..." />
                            <button class="search-button" type="submit"></button>
                        </div>
                    </form>
                </div><!-- /.search-area -->
            </div>
            <div class="indicator">
                <button type="button" class="indicator-btn" onclick="openProfile()">
                    <i class="fa fa-ellipsis-v" aria-hidden="true"></i>
                </button>
                <div class="mobile-topbar-nav social">
                    <button type="button" class="topbar-close-btn" onclick="closeProfile()">
                        <i class="icon fa fa-times fa-fw"></i>
                    </button>
                    <ul>
                        @auth
                            @includeIf('components.mobile.profile')
                        @else
                            <li>
                                <a href="#"><i class="icon fa fa-info"></i>
                                    Please Login to see your profile
                                </a>
                            </li>
                        @endauth
                        <li>
                            <a href="{{ route('user.wishlist.view') }}"><i class="icon fa fa-heart"></i>
                                Wishlist
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('user.cart.index') }}"><i class="icon fa fa-shopping-cart"></i>
                                My Cart
                            </a>
                        </li>
                        <li>
                            <a href="{{ route('user.checkout') }}" id="checkout"><i class="icon fa fa-check"></i>

                                CheckOut

                            </a>
                        </li>
                        @auth
                            <li>
                                <a href="{{ route('user.dashboard') }}" target="_blank"><i class="icon fa fa-user"></i>
                                    My Account
                                </a>
                            </li>
                        @else
                            <li>
                                <a href="{{ route('login') }}"><i class="icon fa fa-lock"></i>

                                    Login
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('register') }}">
                                    <i class="icon fa fa-lock"></i>

                                    Register
                                </a>
                            </li>
                        @endauth
                    </ul>
                    <div class="logo">
                        <a href="{{ url('/') }}">
                            <img src="{{ asset($setting->logo) }}" alt="">
                        </a>
                    </div>
                    <ul class="link social-links text-center">
                        <li class="fb pull-left">
                            <a target="_blank" rel="nofollow" href="{{ $setting->facebook }}" title="Facebook">
                                
                            </a>
                        </li>
                        <li class="tw pull-left">
                            <a target="_blank" rel="nofollow" href="{{ $setting->twitter }}"
                            title="Twitter">
                                
                            </a>
                        </li>
                    
                        <li class="whatsapp pull-left">
                            <a target="_blank" rel="nofollow" href="{{ $setting->whatsapp }}"
                            title="PInterest">
                            </a>
                        </li>
                        <li class="linkedin pull-left">
                            <a target="_blank" rel="nofollow"
                            href="{{ $setting->linkedin }}" title="Linkedin">
                                
                            </a>
                        </li>
                        <li class="youtube pull-left">
                            <a target="_blank" rel="nofollow"
                            href="{{ $setting->youtube }}" title="Youtube">
                                
                            </a>
                        </li>
                    </ul>
                    <div class="mobile-copyright">
                        <span>All Right Reserved <a href="epec.com.bd">EPEC.</a></span>
                        <span>Developed & Maintain By<a href="bitscol.com">BITSCOL</a></span>
                    </div>
                </div>

            </div>
        </div>
        <div class="logo">
            <a href="{{ url('/') }}">
                <img src="{{ asset($setting->logo) }}" alt="">
            </a>
        </div><!-- /.logo -->
    </div>
    <div id="desktop-header" class="fixed">
        <div class="top-bar animate-dropdown">
            <div class="container">
                <div class="header-top-inner" id="header-top-inner">
                    <div class="cnt-account">
                        <ul class="list-unstyled">
                            <li>
                                <a href="{{ route('user.wishlist.view') }}"><i class="icon fa fa-heart"></i>
                                    Wishlist
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('user.cart.index') }}"><i class="icon fa fa-shopping-cart"></i>
                                    My Cart
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('user.checkout') }}" id="checkout"><i class="icon fa fa-check"></i>
                                    CheckOut
                                </a>
                            </li>
                            @auth
                                <li>
                                    <a href="{{ route('user.dashboard') }}" target="_blank"><i class="icon fa fa-user"></i>
                                        My Account
                                    </a>
                                </li>
                            @else
                                <li>
                                    <a href="{{ route('login') }}"><i class="icon fa fa-lock"></i>
                                        Login
                                    </a>
                                </li>
                                <li>
                                    <a href="{{ route('register') }}"><i class="icon fa fa-lock"></i>
                                        Register
                                    </a>
                                </li>
                            @endauth
                        </ul>
                    </div><!-- /.cnt-account -->

                    <div class="cnt-block">
                        
                    </div><!-- /.cnt-cart -->
                    <div class="clearfix"></div>
                </div><!-- /.header-top-inner -->
            </div><!-- /.container -->
        </div><!-- /.header-top -->
        <!-- ===================== TOP MENU : END ==================== -->
        <div class="main-header">
            <div class="container">
                
                <div class="row" id="main-header">
                    <div class="col-xs-12 col-sm-12 col-md-2 logo-holder">
                        <!-- ==================== LOGO ================= -->
                        <div class="logo">
                            <a href="{{ url('/') }}">
                                <img src="{{ asset($setting->logo) }}" alt="">
                            </a>
                        </div><!-- /.logo -->
                        <!-- ======== LOGO : END ===== -->
                    </div><!-- /.logo-holder -->

                    <div class="col-xs-12 col-sm-12 col-md-7 top-search-holder">
                        <!-- /.contact-row -->
                        <!-- ================ SEARCH AREA ===================== -->
                        <div class="search-area">
                            <form action="{{ route('product.search') }}" method="GET">
                                
                                <div class="control-group">
                                    <input class="search-field" name="search" placeholder="Search here..." />
                                    <button class="search-button" type="submit"></button>
                                </div>
                            </form>
                        </div><!-- /.search-area -->
                        <!-- =========== SEARCH AREA : END ============= -->
                    </div><!-- /.top-search-holder -->

                    <div class="col-xs-12 col-sm-12 col-md-3 animate-dropdown top-cart-row">
                        <!-- ==== SHOPPING CART DROPDOWN ======= -->

                        <div class="dropdown dropdown-cart">
                            <a href="#" class="dropdown-toggle lnk-cart" data-toggle="dropdown">
                                <div class="items-cart-inner">
                                    <div class="basket">
                                        <i class="glyphicon glyphicon-shopping-cart"></i>
                                    </div>
                                    <div class="basket-item-count"><span class="count" id="count"> {{Cart::content()->count()}}</span></div>
                                    <div class="total-price-basket">
                                        <span class="lbl">cart - </span>
                                        <span class="total-price">
                                            <span class="sign">৳</span><span class="value total"
                                                id="total">{{Cart::total()}}</span>
                                        </span>
                                    </div>


                                </div>
                            </a>
                            <ul class="dropdown-menu">
                                <li id="mini-cart-list">
                                    <div class="cart-item product-summary" id="mini-cart">
                                        @forelse( Cart::content() as $item)
                                        <div class="row">
                    						<div class="col-xs-4">
                    							<div class="image">
                    								<img src="{{asset($item?->options['image'] ?? '')}}" alt="">
                    							</div>
                    						</div>
                    						<div class="col-xs-7">
                    							
                    							<h3 class="name">{{$item->name}}</h3>
                    							<div class="price">৳ {{$item->price}}</div>
                    						</div>
                    						<div class="col-xs-1 action">
                    							
                    							<a  href="{{route('cart.remove',$item->rowId)}}"><i class="fa fa-trash"></i></a>
                    						</div>
                    					</div>
                    					<hr>
                                        @empty
                                            No Item Found
                                        @endforelse
                                    </div><!-- /.cart-item -->
                                    <div class="clearfix"></div>

                                    <div class="clearfix cart-total">
                                        <div class="pull-right">

                                            <span class="text">Sub Total :</span><span class='price total'>৳ {{Cart::total()}}</span>

                                        </div>
                                        <div class="clearfix"></div>

                                        <a href="{{ route('user.cart.index') }}"
                                            class="btn btn-upper btn-primary btn-block m-t-20">My Cart</a>
                                    </div><!-- /.cart-total-->


                                </li>
                            </ul><!-- /.dropdown-menu-->
                        </div><!-- /.dropdown-cart -->

                        <!-- ======= SHOPPING CART DROPDOWN : END======= -->
                    </div><!-- /.top-cart-row -->
                </div><!-- /.row -->

            </div><!-- /.container -->

        </div><!-- /.main-header -->

        <!-- ===================== NAVBAR ===================== -->
        <div class="header-nav animate-dropdown">
            <div class="container">
                <div class="yamm navbar navbar-default" role="navigation">
                    <div class="navbar-header">
                        <button data-target="#mc-horizontal-menu-collapse" data-toggle="collapse"
                            class="navbar-toggle collapsed" type="button">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                    </div>
                    <div class="nav-bg-class">
                        <div class="navbar-collapse collapse" id="mc-horizontal-menu-collapse">
                            <div class="nav-outer">
                                <ul class="nav navbar-nav">
                                    <li class="@yield('home') yamm-fw">
                                        <a href="{{ url('/') }}" 
                                            class="dropdown-toggle">Home</a>

                                    </li>
                                    
                                    @foreach ($categories as $category)
                                        @if($category->show_on_navbar==1)
                                        <li class="dropdown yamm mega-menu @yield($category->category_name_en)">
                                            @php
                                                $hasSubCategory = \App\Models\SubCategory::where('category_id', $category->id)->count();
                                            @endphp
                                            <a href="{{route('product.parent.category',['id'=>$category->id,'slug'=>$category->category_slug_en])}}" data-hover="{{$hasSubCategory > 0 ? 'dropdown' : '' }}" class="dropdown-toggle"
                                                data-toggle="{{$hasSubCategory > 0 ? 'dropdown' : '' }}">
                                                {{ $category->category_name_en }}
                                            </a>
                                            <ul class="dropdown-menu container">
                    
                                                <li>
                                                    <div class="yamm-content ">
                                                        <div class="row">
                                                            @foreach ($subCategories as $subCategory)
                                                                @if ($category->id == $subCategory->category_id)
                                                                    <div class="col-xs-12 col-sm-6 col-md-2 col-menu">
                                                                        <h2 class="title">
                                                                            
                                                                            <a
                                                                                href="{{ route('product.category', ['id' => $subCategory->id, 'slug' => $subCategory->subcategory_slug_en]) }}">
                                                                                {{ $subCategory->subcategory_name_en }}
                                                                                
                                                                            </a>
                                                                        </h2>
                                                                        <ul class="links">
                                                                            @foreach ($subSubCategories as $subSubCategory)
                                                                                @if ($subCategory->id == $subSubCategory->subcategory_id)
                                                                                    <li>
                                                                                        <a href="{{ route('product.subSubCategory', ['id' => $subSubCategory->id, 'slug' => $subSubCategory->subsubcategory_slug_en]) }}">{{ $subSubCategory->subsubcategory_name_en }}</a>
                                                                                    </li>
                                                                                @endif
                                                                            @endforeach
                                                                        </ul>
                                                                    </div><!-- /.col -->
                                                                @endif
                                                            @endforeach
                                                        </div>
                                                    </div>

                                                </li>
                                            </ul>

                                        </li>
                                    @endif
                                    @endforeach
                                    
                                </ul><!-- /.navbar-nav -->
                                <div class="clearfix"></div>
                            </div><!-- /.nav-outer -->
                        </div><!-- /.navbar-collapse -->


                    </div><!-- /.nav-bg-class -->
                </div><!-- /.navbar-default -->
            </div><!-- /.container-class -->

        </div><!-- /.header-nav -->
    </div>

    <!-- ======== NAVBAR : END ============== -->

</header>
