
<div class="product">
    <div class="product-image">
        <div class="image">
            <a href="{{ route('product.detail', ['id' => $product->id, 'slug' => $product->product_slug_en]) }}">
                <img src="{{ asset($product->product_thumbnail) }}" alt="{{ $product->product_name_en }}">
            </a>
        </div><!-- /.image -->

        @if ($product->discount == null)
            <div class="tag new">
                <span>
                    New
                </span>
            </div>
        @else
            <div class="tag hot">
                <span>
                    @if ($product->discount_type == 'flat')
                        
                        {{ $product->discount }} TK Off
                    @else
                        {{ $product->discount }}% Off
                    @endif
                </span>
            </div>
        @endif
    </div><!-- /.product-image -->


    <div class="product-info text-left">
        <h3 class="name">
            <a href="{{ route('product.detail', ['id' => $product->id, 'slug' => $product->product_slug_en]) }}">
                {{ $product->product_name_en }}
            </a>
        </h3>
        <div class="rating" style="color: #ffc808">
            @php
                
                $rating = $product->reviews->avg('rating');
            @endphp
            @for ($i = 1; $i <= 5; $i++)
                <i class="glyphicon glyphicon-star{{ $i <= $rating ? '' : '-empty' }}"></i>
            @endfor
        </div>
        <div class="description"></div>

        <div class="product-price">
            @if ($product->discount == null)
                <span class="price">
                    ৳{{ $product->discount_price }}
                </span>
            @else
                <span class="price">
                    ৳{{ $product->discount_price }}
                </span>
                <span class="price-before-discount">
                    ৳{{ $product->selling_price }}
                </span>
            @endif
                <a href="{{ route('product.detail', ['id' => $product->id, 'slug' => $product->product_slug_en]) }}" id="mobile-view-btn" class="btn btn-primary icon"><i class="fa fa-eye"></i> View</a>

        </div><!-- /.product-price -->

    </div><!-- /.product-info -->
    <div class="cart clearfix animate-effect" id="desktop-view-btn">
        <div class="action">
            <ul class="list-unstyled">
                <li class="add-cart-button btn-group">
                    <!--<button data-toggle="modal" id="product-view" onClick="viewProduct({{ $product->id }})"-->
                    <!--    data-target="#view-product-modal" class="btn btn-primary icon" type="button"-->
                    <!--    data-original-title="View Product" title="">-->
                    <!--    <i class="fa fa-eye"></i>-->
                    <!--</button>-->
                    <a class="btn btn-primary icon" href="{{ route('product.detail', ['id' => $product->id, 'slug' => $product->product_slug_en]) }}"
                        data-original-title="View Product" title="View Product">
                        <i class="fa fa-eye"></i>
                    </a>



                </li>

                <li>
                    <input type="hidden" name="wishlist_add" value="{{ $product->id }}">
                    {{-- <a href="#" data-toggle="tooltip" class="add-to-cart add-to-wishlist" title="" data-original-title="Wishlist">
                         <i class="icon fa fa-heart"></i>
                    </a> --}}
                    <button onclick="addToWishList({{ $product->id }})" data-toggle="tooltip"
                        class="btn add-to-wishlist" title="" data-original-title="Wishlist">
                        <i class="icon fa fa-heart"></i>
                    </button>
                </li>


            </ul>
        </div><!-- /.action -->
    </div><!-- /.cart -->
</div><!-- /.product -->
