@if($hotDealAvaliable)
<div class="sidebar-widget hot-deals wow fadeInUp outer-bottom-xs">
    <h3 class="section-title">Hot Deals
    </h3>
    <div class="owl-carousel sidebar-carousel custom-carousel owl-theme outer-top-ss">
        @foreach ($products as $product)
            <div class="item">
                <div class="products">
                    <div class="hot-deal-wrapper">
                        <div class="image">
                            <img src="{{ asset($product->product_thumbnail) }}" alt="{{ $product->product_name_en }}">
                        </div>
                        <div class="sale-offer-tag">
                            <div class="dicount-price">
                                @if ($product->discount_type == 'flat')
                                    {{ $product->discount }} TK Off
                                @else
                                    {{ $product->discount }}% Off
                                @endif
                            </div>
                        </div>
                        <div class="timing-wrapper">
                            <div class="box-wrapper">
                                <div class="date box">
                                    <span class="day-key">120</span>
                                    <span class="value">DAYS</span>
                                </div>
                            </div>
            
                            <div class="box-wrapper">
                                <div class="hour box">
                                    <span class="hour-key">20</span>
                                    <span class="value">HRS</span>
                                </div>
                            </div>
            
                            <div class="box-wrapper">
                                <div class="minutes box">
                                    <span class="min-key">36</span>
                                    <span class="value">MINS</span>
                                </div>
                            </div>
            
                            <div class="box-wrapper hidden-md">
                                <div class="seconds box">
                                    <span class="sec-key">36</span>
                                    <span class="value">SECONDS</span>
                                </div>
                            </div>
                        </div>
                    </div><!-- /.hot-deal-wrapper -->
            
                    <div class="product-info text-left m-t-20">
                        <h3 class="name">
                            <a href="{{ route('product.detail', ['id' => $product->id, 'slug' => $product->product_slug_en]) }}">
                                {{$product->product_name_en }}
                            </a>
                        </h3>
                        <div class="rating rateit-small"></div>
            
                        <div class="product-price">
                            <span class="price">
                                ৳{{ $product->discount_price }}
                            </span>
            
                            <span
                                class="price-before-discount">৳{{  $product->selling_price }}</span>
            
                        </div><!-- /.product-price -->
            
                    </div><!-- /.product-info -->
            
                    <div class="cart clearfix animate-effect">
                        <div class="action">
            
                            <div class="add-cart-button btn-group">
                                <button class="btn btn-primary icon" type="button" onClick="viewProduct({{ $product->id }})"
                                    data-toggle="modal" data-target="#view-product-modal">
                                    <i class="fa fa-eye"></i>
                                </button>
                                <input type="hidden" name="add_to_cart" class="product-id" value="{{ $product->id }}">
                                <button class="btn btn-primary cart-btn" type="button"
                                    onClick="addToCart()"> Add To Cart</button>
            
                            </div>
            
                        </div><!-- /.action -->
                    </div><!-- /.cart -->
                </div>
            </div>
        @endforeach
    </div><!-- /.sidebar-widget -->
</div>
@endif

<script>
        
    var countDownDate =new Date("{{$hotDealExpireDate}}").getTime();
    var x=setInterval(function() {
            
        var now = new Date().getTime();
                
        var distance = countDownDate - now;
                
        var days = Math.floor(distance / (1000 * 60 * 60 * 24));
        var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
        var seconds = Math.floor((distance % (1000 * 60)) / 1000);
            
        $('.day-key').html(days);   
        $('.hour-key').html(hours); 
        $('.min-key').html(minutes); 
        $('.sec-key').html(seconds);
    }, 999);
        
</script>
