@extends('layouts.admin-layout')
@section('title','Edit Role')
@section('roles','active show-sub')
@section('add-roles','active')
@section('content')
<nav class="breadcrumb sl-breadcrumb">
  <a class="breadcrumb-item" href="{{route('admin.dashboard')}}">{{__('Dashboard')}}</a>
  <a class="breadcrumb-item" href="{{route('roles.index')}}">{{__('Role')}}</a>
  <span class="breadcrumb-item active">Edit Role</span>
</nav>

<div class="sl-pagebody">
    <div class="row row-sm">
        <div class="col-md-12">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">Edit Role</h6>
                <form action="{{route('roles.update',$role->id)}}" class="form-layout" method="POST" >
                    @csrf
                    @method('PUT')
                    
                    <div class="form-group">
                        <label class="form-control-label">Role : <span class="tx-danger">*</span></label>
                        <input class="form-control" type="text" name="name" value="{{$role->name}}" placeholder="Enter Role Name">
                        @error('name')
                            <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    
                    <div style="display: flex;flex-wrap: wrap;">
                        
                       
                        @foreach($permissions as $permission)
                        <label  style="display: flex;flex-wrap: wrap; align-items:center; justify-content:center; margin: 10px 15px" for="permission-{{$permission->id}}">
                            <input type="checkbox" id="permission-{{$permission->id}}" {{in_array($permission->id,$role_permissions) ? 'checked' : ''}} value="{{$permission->id}}" name="permissions[]" multiple style="margin-right: 10px" />
                            <p class="badge badge-success" style="margin-bottom: 0"> {{$permission->name}}</p>
                        </label>
                        @endforeach
                        @error('permissions')
                            <p class="text-danger">{{$message}}</p>
                        @enderror
                        
                    </div>
                    
                    
                    <div class="form-layout-footer">
                        <button class="btn btn-info mg-r-5">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
    <script type="text/javascript">
        //Product Thumbnail Preview
        var loadFile = function(event) {
        var reader = new FileReader();
            reader.onload = function(){
                var output = document.getElementById('preview');
                output.src = reader.result;
                };
            reader.readAsDataURL(event.target.files[0]);
        };
        @if (session()->has('error'))
            Swal.fire({
                icon:'error',
                text:"{{session('error')}}"
            })
        @endif
    </script>
@endsection