@extends('layouts.admin-layout')
@section('title', 'All Quotes')
@section('quote', 'active')
@section('content')
    <nav class="breadcrumb sl-breadcrumb">
        <a class="breadcrumb-item" href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
        <span class="breadcrumb-item active">Quote</span>
    </nav>

    <div class="sl-pagebody">
        <div class="row row-sm">
            <div class="col-12">
                <div class="card pd-10 pd-sm-20">
                    <h6 class="card-body-title">Quote From --{{ $quote->name }} -- for
                        {{ $quote->product->product_name_en }}</h6>
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table">
                                <tr>
                                    <th>Name</th>
                                    <td>{{ $quote->name }}</td>
                                </tr>
                                <tr>
                                    <th>Phone Number</th>
                                    <td>{{ $quote->phone }}</td>
                                </tr>
                                <tr>
                                    <th>Email Address</th>
                                    <td>{{ $quote->email }}</td>
                                </tr>
                                <tr>
                                    <th>Company Or Busienss Name </th>
                                    <td>{{ $quote?->b_name ? $quote?->b_name : '--' }}</td>
                                </tr>
                                <tr>
                                    <th>Requirments </th>
                                    <td>{{ $quote->requirments }}</td>
                                </tr>
                                <tr>
                                    <th>Attached File </th>
                                    
                                    <td><a href="{{ asset($quote->file) }}" download="{{asset($quote->file)}}" class="btn btn-success btn-sm" >
                                        <i class="fa fa-download"></i>Download Now
                                        </a>
                                    </td>
                                </tr>
                            </table>
                        </div>

                        <div class="col-md-6">
                            <table class="table">
                                <tr>
                                    <th>Prodcut ID</th>
                                    <td>{{ $quote->product->id }}</td>
                                </tr>
                                <tr>
                                    <th>Prodcut Name</th>
                                    <td>{{ $quote->product->product_name_en }}</td>
                                </tr>
                                <tr>
                                    <th>Product Stock Quantity</th>
                                    <td>{{ $quote->product->product_quantity_en }}</td>
                                </tr>
                                <tr>
                                    <th>Requirement Quantity</th>
                                    <td>{{ $quote->qty }}</td>
                                </tr>
                                <tr>
                                    <th>Price</th>
                                    <td>{{ $quote->product->discount_price }} TK</td>
                                </tr>
                                
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection
