@extends('layouts.admin-layout')
@section('title', 'Edit Page')
@section('content')
    <nav class="breadcrumb sl-breadcrumb">
        <a class="breadcrumb-item" href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
        <span class="breadcrumb-item active">Page</span>
    </nav>

    <div class="sl-pagebody">
        <div class="row row-sm">
            <div class="col-md-12">
                <div class="card pd-10 pd-sm-20">
                    <h6 class="card-body-title">Edit Page - {{ $page->title }}</h6>
                    <form action="{{ route('page.update', $page->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="form-group">
                            <label class="form-control-label">Page Title: <span class="tx-danger">*</span></label>
                            <input class="form-control" type="text" name="title" value="{{ $page->title }} "
                                placeholder="Enter Page Title" required>
                            @error('title')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label class="form-control-label" for="description">Page Description
                                <span class="tx-danger">*</span>
                            </label>
                            <textarea name="description" class="text-editor" id="description">{{ $page->description }}</textarea>
                            @error('description')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <button class="btn btn-success" type="submit">Save</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script type="text/javascript">
        $('#description').summernote({
            height: 250
        })
        @if (session()->has('error'))
            Swal.fire({
                icon: 'error',
                text: "{{ session('error') }}"
            })
        @endif
    </script>
@endsection
