<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create( 'states', function ( Blueprint $table )
        {
            $table->id();
            $table->unsignedSmallInteger( 'division_id' );
            $table->foreignId( 'district_id' )->constrained()->cascadeOnDelete();
            $table->string( 'name' );
            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists( 'states' );
    }
}
