<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBrandsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create( 'brands', function ( Blueprint $table )
        {
            $table->id();
            $table->string( 'brand_name_en' )->nullable();
            $table->string( 'brand_slug_en' )->nullable();
            $table->string( 'brand_name_bn' )->nullable();
            $table->string( 'brand_slug_bn' )->nullable();
            $table->string( 'brand_image' )->nullable();
            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists( 'brands' );
    }
}
