<?php

namespace App\View\Composers;

use App\Models\Deal;
use App\Models\Product;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;


class HotDealComposer
{

    /**
     * Bind data to the view.
     *
     * @param  \Illuminate\View\View  $view
     * @return void
     */
    
    
    public function compose( View $view )
    {
        $hotDeal=Deal::where('deal_type','hot_deals')->where('status','active')->first();
        
        $hotDealAvaliable=\Carbon\Carbon::parse($hotDeal->end_date)->format('Y-m-d') >= \Carbon\Carbon::now()->format('Y-m-d');
        $hotDealExpireDate=\Carbon\Carbon::parse($hotDeal->end_date)->format('M d ,Y');
            
        
        if($hotDealAvaliable){
            $products = Product::with(['reviews' => function ($status)
            {
                $status->approve();
            },
            ])->active()->where('hot_deals', 1)->take(8)->get();
        }else {
            $products=null;
        }
        $view->with( ['products'=>$products,'hotDealAvaliable'=>$hotDealAvaliable,'hotDealExpireDate'=>$hotDealExpireDate] );
    }
}