<?php

namespace App\View\Composers;

use App\Models\Deal;
use App\Models\Product;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;


class FeaturedOfferComposer
{

    /**
     * Bind data to the view.
     *
     * @param  \Illuminate\View\View  $view
     * @return void
     */
    
    
    public function compose( View $view )
    {
        $featureDeals=Deal::where('deal_type','featured')->where('status','active')->first();
        
        $featureofferAvaliable=\Carbon\Carbon::parse($featureDeals->end_date)->format('Y-m-d') >= \Carbon\Carbon::now()->format('Y-m-d');
        
        if($featureofferAvaliable){
            $products = Product::with(['reviews' => function ($status)
            {
                $status->approve();
            },
            ])->active()->where('featured', 1)->take(8)->get();
        }else {
            $products=null;
        }
        $view->with( ['products'=>$products,'featureofferAvaliable'=>$featureofferAvaliable] );
    }
}