<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Product extends Model
{
    use HasFactory;
    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = [
        'brand_id',
        'category_id',
        'subcategory_id',
        'subsubcategory_id',
        'product_name_en',
        'product_name_bn',
        'product_slug_en',
        'product_slug_bn',
        'product_code',
        'product_quantity_en',
        'product_quantity_bn',
        'sells',
        'product_tags_en',
        'product_tags_bn',
        'product_color_en',
        'product_color_bn',
        'product_size_en',
        'product_size_bn',
        'product_weight_en',
        'product_weight_bn',
        'unit',
        'selling_price',
        'discount',
        'discount_type',
        'discount_price',
        'product_thumbnail',
        'thumbnail_size',
        'product_type',
        'hot_deals',
        'hightlight_attribute',
        'featured',
        'special_offer',
        'special_deals',
        'short_desc_en',
        'short_desc_bn',
        'full_desc_en',
        'full_desc_bn',
        'is_price_variant',
        'price_variants',
        'status',
        'hide_size_weight',
    ];
    
    public function setPriceVariantsAttribute($value)
    {
        $this->attributes['price_variants'] = $value ? json_encode($value) : null;
    }
    
    public function getPriceVariantsAttribute($value)
    {
        return $value ? json_decode($value) : null;
    }

    //Active Scopre
    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }
    /**
     * Get category for the Product
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function category(): HasOne
    {
        return $this->hasOne(Category::class, 'id', 'category_id');
    }
    /**
     * Get sub category for the Product
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function subCategory(): HasOne
    {
        return $this->hasOne(SubCategory::class, 'id', 'subcategory_id');
    }
    /**
     * Get sub sub categoryfor the Product
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function subSubCategory(): HasOne
    {
        return $this->hasOne(SubSubCategory::class, 'id', 'subsubcategory_id');
    }
    /**
     * Get all of the multiple images for the Product
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function images(): HasMany
    {
        return $this->hasMany(ProductMultipleImage::class);
    }
    /**
     * Get all of the attributes for the Product
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function productAttributes(): HasMany
    {
        return $this->hasMany(ProductAttribute::class);
    }
    /**
     * Get all of the  review for the Product
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function reviews(): HasMany
    {
        return $this->hasMany(Review::class);
    }
    /**
     * 
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function orderItem(): HasOne
    {
        return $this->hasOne(OrderItem::class);
    }

}