<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Option;
use App\Models\Order;
use App\Models\OrderItem;
use App\Models\Setting;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use PDF;

class OrderController extends Controller
{
    //Indexing All Order
    public function index()
    {
        $orders = Order::where('user_id', Auth::id())->latest()->get();
        $user   = User::findOrFail(Auth::id());
        return view('user.order.index', compact('orders', 'user'));

    }
    //Indexing Return Order
    public function returnOrder()
    {
        $orders = Order::where('user_id', Auth::id())->where('status', 'returned')->latest()->get();
        $user   = User::findOrFail(Auth::id());
        return view('user.order.return', compact('orders', 'user'));

    }
    //Indexing Cancel Order
    public function cancelOrder()
    {
        $orders = Order::where('user_id', Auth::id())->where('status', 'cenceled')->latest()->get();
        $user   = User::findOrFail(Auth::id());
        return view('user.order.cancel', compact('orders', 'user'));

    }
    //Onder Information
    public function getOrderInfo($orderId)
    {
        $order      = Order::with('division', 'district', 'state')->findOrFail($orderId);
        $orderItems = OrderItem::with('product')->where('order_id', $orderId)->get();
        
        $user       = User::findOrFail(Auth::id());
        return view('user.order.order-info', compact('order', 'orderItems', 'user'));
    }
    // Order Invoie
    public function invoice($orderId)
    {
        $setting     = Setting::findOrFail(1);
        $order       = Order::with('division', 'district', 'state')->findOrFail($orderId);
        $sellerNotes = Option::where('key', '=', 'order_note')->first();
        $orderItems  = OrderItem::with('product')->where('order_id', $orderId)->get();
        // return view('user.order.invoice', compact('order', 'orderItems', 'setting','sellerNotes'));
        // dd(url($setting->logo),public_path($setting->logo));
        $pdf = PDF::loadview('user.order.invoice', compact('order', 'orderItems', 'sellerNotes'))->setOptions([
                'tempDir'              => public_path(),
                'chroot'               => public_path(),
                'isHtml5ParserEnabled' => true,
                'isPhpEnabled'         => true,
                'isPhpExecEnabled'     => true,
                'isPhpNativeEnabled'   => true,
                'isRemoteEnabled'      => true,
                'base_path'            => public_path(),
        ]);
        return $pdf->download('steel-bazar.pdf');
    }
    //Order Send To Admin for return
    public function orderReturn(Request $request, $orderId)
    {

        $orderReturn = Order::findOrFail($orderId)->update([
            'return_reason' => $request->return_reason,
            'return_date'   => Carbon::now(),
            'status'        => 'returned',
        ]);
        if ($orderReturn)
        {
            return redirect()->back()->withSuccess('Order Return Request Send To Authority');
        }
        else
        {
            return redirect()->back()->withInput()->withError('Order Return Request Send Fail');
        }
    }
    //Showing Order Tracking Form
    public function trackingForm()
    {
        return view('user.order.track-form');
    }
    //Order tracking
    public function orderTrack(Request $request)
    {
        $order = Order::with('user')->where('invoice_no', $request->invoice_no)->first();
        return view('user.order.track', compact('order'));
    }
}