<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\District;
use App\Models\Division;
use App\Models\ShippingAddress;
use App\Models\ShippingCost;
use App\Models\State;
use Gloudemans\Shoppingcart\Facades\Cart;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use App\Helpers\Supports;

class CheckoutController extends Controller
{
    public function index()
    {
        $shippingAddress = ShippingAddress::where('user_id', '=', Auth::id())->get();
        if (Supports::getCartTotal() > 0)
        {
            if (Session::has('coupon'))
            {

                $cartProducts = Supports::getCartCheckoutItems();
                $subtotal     = Supports::getCartTotal();
                $total        = Session::get('coupon')['totalAmount'];
                $costs        = ShippingCost::latest()->get();
                return view('user.checkout', compact('cartProducts', 'subtotal', 'total', 'costs', 'shippingAddress'));
            }
            else
            {

                $cartProducts = Supports::getCartCheckoutItems();
                $total        = Supports::getCartTotal();
                $costs        = ShippingCost::latest()->get();
                return view('user.checkout', compact('cartProducts', 'total', 'costs', 'shippingAddress'));
            }
        }
        else
        {
            return redirect()->to('/')->withError('Please Add At least One Product to your Cart');
        }

    }
    public function getDivision()
    {
        $divisions = Division::orderBy('name', 'ASC')->get();
        return response()->json(['divisions' => $divisions]);
    }
    public function getDistrict($id)
    {

        $districts = District::where('division_id', $id)->orderBy('name', 'ASC')->get();
        return response()->json(['districts' => $districts]);
    }
    public function getState($id)
    {

        $states = State::where('district_id', $id)->orderBy('name', 'ASC')->get();
        return response()->json(['states' => $states]);
    }
    //Store Shipping Info
    public function storeShippingInfo(Request $request)
    {
        if (empty($request->address_id))
        {
            $request->validate([
                'name'           => 'required',
                'email'          => 'required',
                'phone'          => 'required',
                'division_id'   => 'required',
                'district_id'    => 'required',
                'state_id'       => 'required',
                'address1'       => 'required',
                'address2'       => 'nullable',
                'post_code'      => 'nullable',
                'notes'          => 'nullable',
                'payment_method' => 'required',
                'shipping_cost'  => 'nullable',
            ]);
        }
        if ($request->address_id)
        {
            $address = ShippingAddress::findOrFail($request->address_id);

            $shippingInfo                   = [];
            $shippingInfo['name']           = $address->name;
            $shippingInfo['email']          = $address->email;
            $shippingInfo['phone']          = $address->phone;
            $shippingInfo['shipping_cost']  = $address->shipping_cost;
            $shippingInfo['division_id']    = $address->division_id;
            $shippingInfo['district_id']    = $address->district_id;
            $shippingInfo['state_id']       = $address->state_id;
            $shippingInfo['address1']       = $address->address1;
            $shippingInfo['address2']       = $address->address2;
            $shippingInfo['post_code']      = $address->post_code;
            $shippingInfo['notes']          = $request->notes;
            $shippingInfo['payment_method'] = $request->payment_method;
        }
        else
        {

            if ($request->save_address === 'on')
            {

                ShippingAddress::create([
                    'user_id'       => Auth::id(),
                    'name'          => $request->name,
                    'email'         => $request->email,
                    'phone'         => $request->phone,
                    'shipping_cost' => $request->shipping_cost ?  $request->shipping_cost : 0,
                    'address_1'     => $request->address1,
                    'address_2'     => $request->address2,
                    'division_id'   => $request->division_id,
                    'district_id'   => $request->district_id,
                    'state_id'      => $request->state_id,
                    'post_code'     => $request->post_code,
                ]);
            }
            $shippingInfo                   = [];
            $shippingInfo['name']           = $request->name;
            $shippingInfo['email']          = $request->email;
            $shippingInfo['phone']          = $request->phone;
            $shippingInfo['division_id']    = $request->division_id;
            $shippingInfo['district_id']    = $request->district_id;
            $shippingInfo['state_id']       = $request->state_id;
            $shippingInfo['address1']       = $request->address1;
            $shippingInfo['address2']       = $request->address2;
            $shippingInfo['post_code']      = $request->post_code;
            $shippingInfo['notes']          = $request->notes;
            $shippingInfo['payment_method'] = $request->payment_method;
            $shippingInfo['shipping_cost']  = $request->shipping_cost;

        }
        $cartProducts    = Supports::getCartCheckoutItems();
        $cartQty         = Supports::getCartCheckoutTotalItem();
        $cartTotalAmount = Supports::getCartTotal();

        if ($request->payment_method === 'stripe') {
            if (Session::has('coupon'))
            {
                $total       = Session::get('coupon')['totalAmount'];
                $totalAmount = intval($shippingInfo['shipping_cost']) + intval($total);
                $cartTotal   = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                return view('user.payment.stripe', compact('shippingInfo', 'cartTotal', 'totalAmount'));
            }
            else
            {
                $cartTotal = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                return view('user.payment.stripe', compact('shippingInfo', 'cartTotal'));
            }

        }
        if ($request->payment_method === 'paypal') {
            if (Session::has('coupon'))
            {
                $total       = Session::get('coupon')['totalAmount'];
                $totalAmount = intval($shippingInfo['shipping_cost']) + intval($total);
                $cartTotal   = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                return view('user.payment.stripe', compact('shippingInfo', 'cartTotal', 'totalAmount'));
            }
            else
            {
                $cartTotal = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                return view('user.payment.stripe', compact('shippingInfo', 'cartTotal'));
            }

        }
        if ($request->payment_method === 'sslcommerz_hosted') {
            if (Session::has('coupon'))
            {
                $total       = Session::get('coupon')['totalAmount'];
                $totalAmount = intval($shippingInfo['shipping_cost']) + intval($total);
                $cartTotal   = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                return view('user.payment.sslcommerz.hosted-checkout', compact('shippingInfo', 'cartProducts', 'cartQty', 'cartTotal', 'totalAmount'));
            }
            else
            {
                $cartTotal = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                return view('user.payment.sslcommerz.hosted-checkout', compact('shippingInfo', 'cartProducts', 'cartQty', 'cartTotal'));
            }
        }
        if ($request->payment_method === 'sslcommerz_easy') {
            if (Session::has('coupon'))
            {
                $total       = Session::get('coupon')['totalAmount'];
                $totalAmount = intval($shippingInfo['shipping_cost']) + intval($total);
                $cartTotal   = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                return view('user.payment.sslcommerz.eassy-checkout', compact('shippingInfo', 'cartProducts', 'cartQty', 'cartTotal', 'totalAmount'));
            }
            else
            {
                $cartTotal = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                return view('user.payment.sslcommerz.eassy-checkout', compact('shippingInfo', 'cartProducts', 'cartQty', 'cartTotal'));
            }
        }
        if ($request->payment_method === 'amaarpay') {
            if (Session::has('coupon'))
            {
                $total       = Session::get('coupon')['totalAmount'];
                $totalAmount = intval($shippingInfo['shipping_cost']) + intval($total);
                $cartTotal   = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                return view('user.payment.amaarpay.index', compact('shippingInfo', 'cartProducts', 'cartQty', 'cartTotal', 'totalAmount'));
            }
            else
            {
                $cartTotal = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                return view('user.payment.amaarpay.index', compact('shippingInfo', 'cartProducts', 'cartQty', 'cartTotal'));
            }

        }
        if (!Session::has('coupon')) {
            $cartTotal = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
            return view('user.payment.cod.index', compact('shippingInfo', 'cartProducts', 'cartQty', 'cartTotal'));
                
        }
            
        $total       = Session::get('coupon')['totalAmount'];
        $totalAmount = intval($shippingInfo['shipping_cost']) + intval($total);
        $cartTotal   = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);

        return view('user.payment.cod.index', compact('shippingInfo', 'cartProducts', 'cartQty', 'cartTotal', 'totalAmount'));    

        
    }

}