<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
     */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */

    protected $redirectTo = RouteServiceProvider::HOME;
    protected function redirectTo()
    {
        if (Auth()->user()->role_id == 1) {
            return route('admin.dashboard');

        }
        elseif (Auth()->user()->role_id == 2) {
            if (\Request::segment(1) == 'login') {
                return route('user.dashboard');
            }
            else {
                return redirect()->back();
            }

        }
        else {
            return route('home');
        }
    }

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }
    
    public function login(Request $request)
    {
       
        $request->validate([
            'login_email' => ['required', 'email'],
            'login_password' => ['required', 'string'],
        ]);

        /** @var User $user */
        $user = User::query()
            ->where('email', $request->input('login_email'))
            ->first();

        if (!$user) {
            return redirect()->back()->withErrors(['login_email'=>'Account Not Found']);
        }
        
        $credentials = [
            'email' =>$request->input('login_email'),
            'password' => $request->input('login_password')
        ];
        $remember = $request->has('remember');
       
        if (Auth::attempt($credentials, $remember)) {
           
            if (Auth()->user()->role_id == 1){
                return redirect()->route('admin.dashboard');
    
            }
           
            $intendedUrl = session()->get('intended_url');
            
            if($intendedUrl){
                
                return redirect()->route($intendedUrl);
            }
            
            return redirect()->route('user.dashboard');
        }
        return redirect()->back()->withErrors(['password'=>'Password does not match']);
    }
}