<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\CategoryRequest;
use Illuminate\Http\Request;
use App\Models\Category;
use Illuminate\Support\Str;
use Intervention\Image\Facades\Image;

class CategoryController extends Controller
{
    //Showing Category 
    public function index()
    {
        $categories = Category::orderBy('category_name_bn','ASC')->get();
        return view( 'admin.category.index', compact( 'categories' ) );
    }
    //Store Category
    public function store( CategoryRequest $request )
    {
            
        try{
            if ( $request->hasFile( 'category_icon' ) )
            {
                $categoryImage = $request->file( 'category_icon' );
                $imageName  = hexdec( uniqid() ) . '.' . $categoryImage->getClientOriginalExtension();
                Image::make( $categoryImage )->save( 'uploads/category/' . $imageName );
                $url = 'uploads/category/' . $imageName;
    
            }
            $create = Category::create( [
                'category_name_en' => $request->category_name_en,
                'category_slug_en' => Str::slug( $request->category_name_en, '-' ),
                'category_name_bn' => $request->category_name_bn,
                'category_icon'    => $url,
                'show_on_navbar'   =>$request->show_on_navbar =='on'? 1 : 0,
            ] );
            
            return redirect()->back()->withSuccess( "{$request->category_name_en} Created Successfully" );
        
        }catch(\Excetion $e) {
             return redirect()->back()->withInput()->withError( $e->getMessage() );
        }
    }
    //Category Edit
    //Category Update
    public function edit( $categoryId )
    {
        $category = Category::findOrFail( $categoryId );
        return view( 'admin.category.edit-category', compact( 'category' ) );
    }
    public function update( Request $request, $categoryId )
    {
        $request->validate([
            'category_name_en' => 'required | string',
            'category_name_bn' => 'integer | nullable | unique:categories,category_name_bn,'.$categoryId,
            'category_icon'    => 'nullable | file',
        ],[
            'category_name_bn.unique' => "This position already taken"
            
        ]);
        
        try{
            if ( $request->hasFile( 'category_icon' ) )
            {
                if(file_exists($request->category_icon_old)){
                    unlink($request->category_icon_old);
                }
                $categoryImage = $request->file( 'category_icon' );
                $imageName  = hexdec( uniqid() ) . '.' . $categoryImage->getClientOriginalExtension();
                Image::make( $categoryImage )->save( 'uploads/category/' . $imageName );
                $url = 'uploads/category/' . $imageName;
    
            }else {
                $url=$request->category_icon_old;
            }
            $update = Category::findOrFail( $categoryId )->update( [
            'category_name_en' => $request->category_name_en,
            'category_slug_en' => Str::slug( $request->category_name_en, '-' ),
            'category_name_bn' => $request->category_name_bn,
            'category_icon'    => $url,
            'show_on_navbar'   =>$request->show_on_navbar =='on'? 1 : 0,
            ] );
            return redirect()->route('admin.category')->withSuccess( "{$request->category_name_en} Updated Successfully" );
        
        }catch(\Excetion $e) {
            return redirect()->back()->withInput()->withError( $e->getMessage() );
        }
    }
    //Category Delete
    public function delete( $categoryId )
    {
        $category = Category::findOrFail( $categoryId );
        $delete   = Category::findOrFail( $categoryId )->delete();
        if ( $delete )
        {
            return redirect()->back()->withSuccess( "{$category->category_name_en} Deleted Successfully" );
        }
        else
        {
            return redirect()->back()->withInput()->withError( "{$category->category_name_en} Delete Fail" );
        }
    }
}
