<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Attribute;
use Illuminate\Http\Request;

class AttributeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $attributes = Attribute::all();
        return view('admin.attribute.index', compact('attributes'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'      => 'required | string',
            'priyority' => 'required | integer',
        ]);
        try {
            Attribute::create($request->all());
            return redirect()->route('product.attributes')->withSuccess('New Attribute Added Successfully');
        }
        catch (\Exception$e)
        {
            return redirect()->back()->withSuccess($e->getMessage());
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\ProductAttribute  $productAttribute
     * @return \Illuminate\Http\Response
     */
    public function edit($attributeId)
    {
        try {
            $attributes = Attribute::findOrFail($attributeId);
            return response()->json([
                'status'  => 'success',
                'data'    => $attributes,
                'message' => "data retrived successfully",
            ]);
        }
        catch (\Exception$e)
        {
            return response()->json([
                'status'  => 'fail',
                'data'    => '',
                'message' => $e->getMessage(),
            ]);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\ProductAttribute  $productAttribute
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, )
    {

        $request->validate([
            'name'      => 'required | string',
            'priyority' => 'required | integer',
        ]);
        try {
            Attribute::findOrFail($request->attribute_id)->update([
                'name'      => $request->name,
                'priyority' => $request->priyority,
            ]);
            return redirect()->route('product.attributes')->withSuccess('Attribute Updated Successfully');
        }
        catch (\Exception$e)
        {
            return redirect()->back()->withSuccess($e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\ProductAttribute  $productAttribute
     * @return \Illuminate\Http\Response
     */
    public function destroy($productAttributeId)
    {
        try {
            
            Attribute::findOrFail( $productAttributeId )->delete();
            return redirect()->back()->withSuccess( 'Attribute Deleted Successfully' );
        }
        catch ( \Exception$e )
        {
            return redirect()->back()->withError( $e->getMessage() );
        }
    }
}