<?php
declare(strict_types=1);

namespace App\Helpers;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;

class AdminPermission 
{
    
    public static function isPermitted(string $permission): bool
    {
        $permissions = self::get();
        
        if($permissions['role_id'] ===1){
            
            return true;
        }
        
        if(!empty($permissions['permissions']) && in_array($permission,$permissions['permissions'])){
            
            return true;
        }
        
        
        return false;
    }


    public static function get(): array
    {
        if (! auth()->check()) {
            return [];
        }

        if (Cache::has(self::cacheKey())) {
            return Cache::get(self::cacheKey(), []);
        }

        self::generate();

        return Cache::get(self::cacheKey(), []);
    }

    private static function cacheKey(): string
    {
        return 'admin_permissions_' . auth()->id();
    }

    public static function generate(): void
    {
        self::forget();

        /** @var User|null $user|null */
        $user = auth()->user();
        $user?->refresh();

        self::set();
    }

    public static function forget(): void
    {
        Cache::forget(self::cacheKey());
    }

    public static function set(): void
    {
        Cache::remember(self::cacheKey(), Carbon::now()->addMinutes(config('session.lifetime')), function () {
            
            return [
                'role_id' => auth()->user()?->adminRole?->id,
                'permissions' => auth()->user()?->adminRole?->permissions()?->pluck('name')?->toArray()
            ];
        });
    }
    
}